// Datoteka simul.h
#include "simul.h"

#include <iostream>
#include <string>
#include <iomanip>
// Makro naredbe
#define BROJ_USLUGA 5
#define VRSTA_USLUGE 1

#define VREME simu.vrati_vreme_simulacije()
#define VRTR(vreme) simu.vrati_vreme_simulacije()+(vreme)
#define TERMINATE(vrednost) simu.unisti_entitet(e, vrednost)

// Ukljucujemo prostore imena simul i std
using namespace simul;
using namespace std;

// Objekat simulacije
simulacija simu;
// Raspodele
raspodela rn1(1), rn2(3), rn3(7), rn4(9), rn5(11), rn6(15), rn7(17),rn8(19);
// Redovi cekanja
red_cekanja red_uni(&simu), red_pak(&simu);
// Salteri
resurs uni(&simu, 1),pak(&simu, 1);
// Funkcije
funkcija func;
//verovatnoca kojom korisnik dolazi u postu u odredjenom vremenskom intervalu
double ver_dol_uni[12] = { 0.000, 0.208, 0.399, 0.486, 0.601, 0.650, 0.715,
0.775, 0.824, 0.890, 0.945, 1.000 };
//vremenski interval u kom dolazi korisnik
double vre_dol_uni[12] = { 0.00, 20.00, 40.00, 60.00, 80.00, 100.00, 120.00,
140.00, 180.00, 200.00, 220.00, 380.00};
//funkcija kojom se vraca realno vreme u koje korisnik dolazi
double vrati_vre_dol_uni(){
	return func.kontinualna(rn7(), ver_dol_uni, vre_dol_uni, 12);
}
//verovatnoca izbora usluge
double izb_usl_uni[BROJ_USLUGA] = { 0.277, 0.447, 0.661, 0.843, 1.00 };
//vrsta usluge
double vrs_usl_uni[BROJ_USLUGA] = { 1.00, 2.00, 3.00, 4.00, 5.00 };
//funkcija kojom vracamo vrednost usluge koju smo izabrali
double izaberi_usl_uni(){
	//vracamo disretnu vrednost, jer se radi o vrsti usluge
	return func.diskretna(rn8(), izb_usl_uni, vrs_usl_uni, BROJ_USLUGA);
}
//verovatnoca kojom se bira za koje vreme se korisnik opsluzuje ukoliko odabere prvu uslugu
double ops_1[5]={0.000,0.414, 0.771, 0.942, 1.000};
// vreme za koje se opsluzi korisnik
double vremena_ops1[5]={ 30.00, 60.00, 90.00, 120.00, 150.00};
//verovatnoca kojom se bira za koje vreme se korisnik opsluzuje ukoliko odabere drugu uslugu
double ops_2[4]={0.000, 0.605, 0.907, 1.000};
// vreme za koje se opsluzi korisnik
double vremena_ops2[4]={ 20.00, 40.00, 60.00, 80.00};
//verovatnoca kojom se bira za koje vreme se korisnik opsluzuje ukoliko odabere trecu uslugu
double ops_3[5]={0.000, 0.518, 0.777, 0.944, 1.000};
// vreme za koje se opsluzi korisnik
double vremena_ops3[5]={ 20.00, 40.00, 60.00, 80.00, 100.00};
//verovatnoca kojom se bira za koje vreme se korisnik opsluzuje ukoliko odabere cetvrtu uslugu
double ops_4[5]={0.000, 0.435, 0.783, 0.956, 1.000};
// vreme za koje se opsluzi korisnik
double vremena_ops4[5]={ 30.00, 60.00, 90.00, 120.00, 150.00};
//verovatnoca kojom se bira za koje vreme se korisnik opsluzuje ukoliko odabere petu uslugu
double ops_5[4]={0.000, 0.469, 0.836, 1.000};
// vreme za koje se opsluzi korisnik
double vremena_ops5[4]={ 20.00, 40.00, 60.00, 80.00};
//ukoliko korisnik zeli vise transakcija odjednom
double koliko_usluga[2]={1.,2.};
//verovatnoca izbora jedne ili dve transakcije
double ver_koliko_usluga[2] = {0.675,1.0};
//funkcija kojom vracamo koliko transakcija zelimo
double broj_usluga(){
	return func.diskretna(rn1(), ver_koliko_usluga,koliko_usluga,2);
}
//funkcija kojom vracamo realno vreme za koje se korisnik opsluzi
double vrati_vre_ops_uni(const double &vrsta_usluge){
	//u zavisnosti od usluge koju je odabrao
	switch (int(vrsta_usluge)){
	case 1:
		return (func.kontinualna(rn2(),ops_1,vremena_ops1,5)*broj_usluga());
	case 2:
		return (func.kontinualna(rn3(),ops_2,vremena_ops2,4)*broj_usluga());
	case 3:
		return (func.kontinualna(rn4(),ops_3,vremena_ops3,5)*broj_usluga());
	case 4:
		return (func.kontinualna(rn5(),ops_4,vremena_ops4,5)*broj_usluga());
	case 5:
		return (func.kontinualna(rn6(),ops_5,vremena_ops5,4)*broj_usluga());		
	}
	return 0;
}

//verovatnoca kojom korisnici dolaze na paketski salter
double ver_dol_pak[5] = { 0.000, 0.417, 0.722, 0.861, 1.000 };
//vremenski intervali u kojim korisnik dolazi
double vre_dol_pak[5] = {  0.00, 200.00, 400.00, 800.00, 1000.00};
//funkcija kojom se vraca realno vreme dolazaka korisnika
double vrati_vre_dol_pak(){
	return func.kontinualna(rn7(), ver_dol_pak, vre_dol_pak, 5);
}
//verovatnoca izbora neke od pismonosno-paketskih usluga
double izb_usl_pak[BROJ_USLUGA] = { 0.440, 0.678, 0.845, 0.928, 1.00 };
//konkretna vrsta usluge
double vrsta_usl_pak[BROJ_USLUGA] = { 1, 2, 3, 4, 5 };
//funkcija koja vracamo celobrojnu vrednost za izabranu uslugu
int izaberi_usl_pak(){
	return int(func.diskretna(rn1(), izb_usl_pak, vrsta_usl_pak, BROJ_USLUGA));
}
//verovatnoca vremenskog intervala opsluge prve usluge
double ops_11[4]={0.000,0.156, 0.565, 1.000};
//realno vreme opsluge
double vremena_ops11[4]={ 20.00, 30.00, 60.00, 90.00};
//verovatnoca vremenskog intervala opsluge druge usluge
double ops_22[3]={ 0.500, 0.833, 1.000};
//realno vreme opsluge
double vremena_ops22[3]={ 120.00, 180.00, 240.00};
//verovatnoca vremenskog intervala opsluge trece usluge
double ops_33[3]={0.200, 0.900, 1.000};
//realno vreme opsluge
double vremena_ops33[3]={ 30.00, 60.00, 90.00};
//verovatnoca vremenskog intervala opsluge cetvrte usluge
double ops_44[2]={ 0.571, 1.000};
//realno vreme opsluge
double vremena_ops44[2]={60.00, 120.00};
//verovatnoca vremenskog intervala opsluge pete usluge
double ops_55[2]={ 0.167, 1.000};
//realno vreme opsluge
double vremena_ops55[2]={ 90.00, 120.00};
//funkcija kojom se vraca realno vreme opsluge
double vrati_vre_ops_pak(const double &vrsta_usluge){
	switch (int(vrsta_usluge)){
	case 1:
		return func.kontinualna(rn2(),ops_11,vremena_ops11,4);
	case 2:
		return func.diskretna(rn3(),ops_22,vremena_ops22,3);
	case 3:
		return func.diskretna(rn4(),ops_33,vremena_ops33,3);
	case 4:
		return func.diskretna(rn5(),ops_44,vremena_ops44,2);
	case 5:
		return func.diskretna(rn6(),ops_55,vremena_ops55,2);
	}
	return 0;
}

//konstante koje govore o kom se dogadjaju radi
const int DOLAZAK_NA_UNIVE = 1;
const int ODLAZAK_SA_UNIVE = 2;
const int DOLAZAK_NA_PAKET = 3;
const int ODLAZAK_SA_PAKET = 4;
const int KRAJ_SIMULACIJE = 5;
//funkcije koje se pozivaju kada odgovaraju broju dogadjaja
void dolazak_na_unive(entitet *e);
void odlazak_sa_unive(entitet *e);
void dolazak_na_paket(entitet *e);
void odlazak_sa_paket(entitet *e);
void kraj_simulacije(entitet *e);
//definicija metode izvrsavanje dogadjaja
void simulacija::izvrsavanje_dogadjaja(int dog, entitet* e) {
	//u zavisnosti od dogadjaja
	switch (dog) {
	case DOLAZAK_NA_UNIVE:
		dolazak_na_unive(e);
		break;
	case ODLAZAK_SA_UNIVE:
		odlazak_sa_unive(e);
		break;
	case DOLAZAK_NA_PAKET:
		dolazak_na_paket(e);
		break;
	case ODLAZAK_SA_PAKET:
		odlazak_sa_paket(e);
		break;
	case KRAJ_SIMULACIJE:
		kraj_simulacije(e);
		break;
	}
}
//u osvom dogadjaju vrsimo preusmeravanje
void dolazak_na_unive(entitet *e)
{
	entitet *fe, *ne;
	// Postavi klijenta u red cekanja
	red_uni.ured(e);
	//ukoliko se pojavi vise od tri korisnika nu redu uplate-isplete
	// Ukoliko je salter raspoloziv
	if (uni.raspoloziv()) {
		// Izvadi prvog klijenta iz reda
		fe = red_uni.izred();
		// Zauzmi jedno mesto u salteru
		uni.zauzmi(fe);
		// Rasporedi klijenta za kraj opsluge
		simu.rasporedi(fe, ODLAZAK_SA_UNIVE, VRTR(vrati_vre_ops_uni(fe->vrati_parametar(VRSTA_USLUGE))));
	}
	// Stvaramo narednog klijenta
	ne = simu.napravi_entitet();
	// Dodeljujemo vrstu usluge
	ne->postavi_parametar(VRSTA_USLUGE, izaberi_usl_uni());
	// Postavljamo vreme narednog dolaska
	simu.rasporedi(ne, DOLAZAK_NA_UNIVE, VRTR(vrati_vre_dol_uni()));
}


// Dogadjaj odlazak klijenta
void odlazak_sa_unive(entitet *e) {
	entitet *fe;
	//verovatnoca kojom se korisnici sa univerzalnog saltera preusmeravaju na paketski
	// Vrati salter;
	uni.oslobodi(e);	
	// Klijent odlazi iz poste - unistavamo tekuceg klijenta
	simu.unisti_entitet(e, 0);
	// Ukoliko red nije prazan
	if (red_uni.velicina()>0) {
		// Izvadi prvog klijenta iz reda
		fe = red_uni.izred();
		// Zauzmi jedno mesto u salteru
		uni.zauzmi(fe);
		// Rasporedi klijenta za kraj opsluge
		simu.rasporedi(fe, ODLAZAK_SA_UNIVE, VRTR(vrati_vre_ops_uni(fe->vrati_parametar(VRSTA_USLUGE))));
	}
}
void dolazak_na_paket(entitet *e)
{
	entitet *fe, *ne;
	// Postavi klijenta u red cekanja
	red_pak.ured(e);
	// Ukoliko je salter raspoloziv
	if (pak.raspoloziv()) {
		// Izvadi prvog klijenta iz reda
		fe = red_pak.izred();
		// Zauzmi jedno mesto u salteru
		pak.zauzmi(fe);
		// Rasporedi klijenta za kraj opsluge 
		simu.rasporedi(fe, ODLAZAK_SA_PAKET, VRTR(vrati_vre_ops_pak(fe->vrati_parametar(VRSTA_USLUGE))));
	}
	// Stvaramo narednog klijenta
	ne = simu.napravi_entitet();
	// Dodeljujemo vrstu usluge
	ne->postavi_parametar(VRSTA_USLUGE, izaberi_usl_pak());
	// Postavljamo vreme narednog dolaska
	simu.rasporedi(ne, DOLAZAK_NA_PAKET, VRTR(vrati_vre_dol_pak()));
}
// Dogadjaj odlazak klijenta
void odlazak_sa_paket(entitet *e) {
	entitet *fe;
	// Vrati salter;
	pak.oslobodi(e);
	// Klijent odlazi iz poste - unistavamo tekuceg klijenta
	simu.unisti_entitet(e, 0);
	// Ukoliko red nije prazan
	if (red_pak.velicina()>0) {
		// Izvadi prvog klijenta iz reda
		fe = red_pak.izred();
		// Zauzmi jedno mesto u salteru
		pak.zauzmi(fe);
		// Rasporedi klijenta za kraj opsluge 
		simu.rasporedi(fe, ODLAZAK_SA_PAKET, VRTR(vrati_vre_ops_pak(fe->vrati_parametar(VRSTA_USLUGE))));
	}
}
// Dogadjaj kraj simulacije
void kraj_simulacije(entitet* e) {
	//unistavamo entitete, uklanjanje
	TERMINATE(1);
}
void print_statistike_reda_cekanja(const red_cekanja& red, const char* opis) {
	statistike stat = red.vrati_statistike();
	// opis parametara redova cekanja
	cout << "STATISTIKE REDA CEKANJA - " << opis << endl;
	cout << "Broj entiteta koji je usao u red cekanja: " << stat.vrati_broj() << endl;
	cout << "Preostali broj entiteta u redu cekanja: " << stat.vrati_tekuci_broj() << endl;
	cout << "Maksimalni broj entiteta u redu: " << stat.vrati_maksimalni_broj() << endl;
	cout << "Srednje vreme cekanja u redu: " << stat.vrati_srednje_vreme() << endl;
	cout << "Srednji broj entiteta u redu: " << stat.vrati_srednji_broj(simu.vrati_vreme_simulacije()) << endl;
	cout << "Broj entiteta koji je prosao kroz red bez zadrzavanja: " << stat.vrati_broj_bez_cekanja() << endl;
	cout << "Procenat ulaza bez zadrzavanja: " << stat.vrati_ucesce_bez_cekanja() << endl;
	cout << "Srednje vreme cekanja u redu (iskljuc. ent. koji se nisu zadrzali): " << stat.vrati_srednje_vreme_bez_cekanja() << endl;
	cout << endl;
}

void print_statistike_resursa(const resurs& salt, const char* opis) {
	statistike stat = salt.vrati_statistike();
	// opis parametara koje prikazujemo za svaki salter
	cout << "STATISTIKE RESURSA - " << opis << endl;
	cout << "Broj entiteta koji je usao u resurs: " << stat.vrati_broj() << endl;
	cout << "Preostali broj entiteta u resursu: " << stat.vrati_tekuci_broj() << endl;
	cout << "Maksimalni broj zauzetih kanala opsluge: " << stat.vrati_maksimalni_broj() << endl;
	cout << "Srednje vreme opsluge: " << stat.vrati_srednje_vreme() << endl;
	cout << "Srednji broj zauzetih kanala: " << stat.vrati_srednji_broj(simu.vrati_vreme_simulacije()) << endl;
	cout << "Iskoriscenost: " << stat.vrati_iskoriscenost(simu.vrati_vreme_simulacije(), salt.vrati_broj_mesta()) << endl;
	cout << endl;
}
int main()
{ 
	simu.rasporedi(simu.napravi_entitet(), DOLAZAK_NA_UNIVE, vrati_vre_dol_uni());
	simu.rasporedi(simu.napravi_entitet(), DOLAZAK_NA_PAKET, vrati_vre_dol_pak());
	simu.rasporedi(simu.napravi_entitet(), KRAJ_SIMULACIJE, 3600);
	simu.izvrsi(1);
	red_uni.finisiraj();
	red_pak.finisiraj();
	uni.finisiraj();
	pak.finisiraj();
	// Stampanje statistika za redove cekanja i salter uni
	print_statistike_reda_cekanja(red_uni, "RED CEKANJA NA UNIVERZALNOM SALTERU");
	print_statistike_resursa(uni, "UNIVERZALNI SALTER");
	//stampanje statistika za redove cekanja i saltere pak
	print_statistike_reda_cekanja(red_pak, "RED CEKANJA NA PAKETSKOM SALTERU");
	print_statistike_resursa(pak, "PAKETSKI SALTER");
	//vreme simulacije
	cout << "Vreme simulacije: " << VREME << endl << endl;

	system("pause");
	return 0; 
}